
/*******************************************************************************/
/*  
	This script produces Figure B2
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/


graph drop _all

// _______________________________
// LOAD PSID DATA 
use "../Data/PSID/psid_occ_h2m.dta", clear
gen Ph2m = 1 - Wh2m // poor hand-to-mouth

// _______________________________
// LWFH* and HPP*
merge m:1 occ using "../Data/onet_occ_clean.dta"
keep if _merge == 3
drop _merge

// _______________________________________________
// Collapse to share h2m
collapse (mean) Ph2m h2m , by(high_pp_binary low_wfh_binary)
tempfile psidreg
save `psidreg'


// _______________________________
// LOAD ASEC DATA
use "../Data/CPS/clean_cps19.dta", clear

// _______________________________
// LWFH* and HPP*
merge m:1 occ using "../Data/onet_occ_clean.dta"
keep if _merge == 3
drop _merge

// _______________________________
// Reverse binary variables
foreach var of varlist college top50 female employer_health own_home born_50states married is_citizen big_firm white fulltime old no_unemp {
	di "`var'"
	qui gen y_`var' = 1 - `var' 	// Get y of interest (e.g. 1 - college = no college) so that coef positive.
}


//_______________________________
// Collapse to share {WFH} x {PP}
collapse (mean) y_* [iw=asecwt], by(high_pp_binary low_wfh_binary)
merge 1:1 low_wfh_binary high_pp_binary using `psidreg', nogen keep(match)

xpose, varname clear
rename (v1 v2 v3 v4) (HWFH_LPP LWFH_LPP HWFH_HPP LWFH_HPP)
rename _varname varname 
order varname 
drop in 1/2

//_______________________________
// RENAME
replace varname = "Below median wage" if varname=="y_top50"
replace varname = "Male" if varname=="y_female"
replace varname = "No employer healthcare" if varname=="y_employer_health"
replace varname = "Rents home" if varname=="y_own_home"	
replace varname = "No college degree" if varname=="y_college"
replace varname = "Born outside US" if varname=="y_born_50states"
replace varname = "Single" if varname=="y_married"
replace varname = "Non-US citizen" if varname=="y_is_citizen"
replace varname = "Small firm (<500 emp.)" if varname=="y_big_firm"
replace varname = "Non-white" if varname=="y_white"
replace varname = "Part-time employed" if varname=="y_fulltime"
replace varname = "Age <50" if varname=="y_old"
replace varname = "Unemployed at all last year" if varname=="y_no_unemp"
replace varname = "Poor hand-to-mouth*" if varname=="Ph2m"
replace varname = "Hand-to-mouth*" if varname=="h2m"

	

//_______________________________
// TAKE DIFFERENCES

gen diffWFH_HPP = LWFH_HPP - HWFH_HPP
gen diffWFH_LPP = LWFH_LPP - HWFH_LPP
gen diffPP_HWFH = HWFH_HPP - HWFH_LPP
gen diffPP_LWFH = LWFH_HPP - LWFH_LPP

//_______________________________
// 1. Conditional on PP


graph drop _all
graph ///
	dot diffWFH_HPP diffWFH_LPP ///
	, over(varname, descending  sort(2) ) ///
	ytitle("More likely >>") ///
	ylabel(, format(%3.2f)) ///
	yline(0, lc(blue) lw(medthick)) ///
	xsize(3) ysize(1)  ///
	title("A. Work-from-home") name(A1) ///
	yscale(r(-0.2 0.6)) ///
	legend(order(1 "High PP" 2 "Low PP") pos("4")) ///
	marker(2, msymbol(X) msize(vlarge))
	
	
//_______________________________
// 2. Conditional on LPP

graph ///
	dot diffPP_LWFH diffPP_HWFH ///
	, over(varname, descending  sort(2)) ///
	ytitle("More likely >>") ///
	ylabel(, format(%3.2f)) ///
	yline(0, lc(blue) lw(medthick)) ///
	xsize(3) ysize(1)  ///
	title("B. Physical proximity") name(A2) ///
	yscale(r(-0.2 0.6)) ///
	legend(order(1 "Low WFH" 2 "High WFH") pos("4")) ///
	marker(2, msymbol(X) msize(vlarge))


graph combine A1 A2, xcommon ycommon name(A)
graph export "../Figures/figb2.eps", replace

// end
